<?php
/**
 * Template to show fly cart icon.
 *
 * @var $icon_position string
 * @var $icon_name string
 *
 * @package SBFW
 */

$settings   = \StorePulse\StoreGrowth\Helper::get_settings( 'spsg_fly_cart_settings' );
$layout     = \StorePulse\StoreGrowth\Helper::find_option_settings( $settings, 'layout', 'side' );
$class_name = 'center' === $layout ? 'spsg-quick-cart-center-layout' : '';

$cart_icon_color      = \StorePulse\StoreGrowth\Helper::find_option_settings( $settings, 'icon_color', '#FFF' );
$action_btn_active_bg = \StorePulse\StoreGrowth\Helper::find_option_settings( $settings, 'buttons_bg_color', '#0875FF' );
?>
<div class="wfc-cart-icon <?php echo esc_attr( $icon_position ); ?>">
	<span class="wfc-open-btn wfc-icon <?php echo esc_attr( $icon_name ); ?>">
		<?php if ( $icon_name === 'shopping-cart-icon-1' ) : ?>
			<svg width='16' height='17' fill='none' class='radio-icon' viewBox='0 0 100 100'
				style='  border-radius: 10px; background: <?php echo esc_attr( $action_btn_active_bg ); ?>;'>
				<g>
					<polygon style='fill: <?php echo esc_attr( $cart_icon_color ); ?>;' class='st0'
						points='57.2,30.9 54.5,30.9 52.4,33 54.8,33.8  ' />
					<polygon style='fill: <?php echo esc_attr( $cart_icon_color ); ?>;' class='st0'
						points='62.3,43 64.4,40.9 64.4,38.2 61.5,40.6  ' />
					<path style='fill: <?php echo esc_attr( $cart_icon_color ); ?>;' class='st0'
						d='M60.2,30.1l-4.9,5.8l3.2,1l1,3.2l5.8-4.9c2-1.8,2.8-4.6,2-7.1C64.7,27.3,61.9,28,60.2,30.1z M63.3,33.4   c-0.7,0-1.2-0.6-1.2-1.3c0-0.7,0.5-1.3,1.2-1.3s1.2,0.6,1.2,1.3C64.6,32.8,64,33.3,63.3,33.4z' />
					<path class='st0'
						d='M53.8,38.7c-1,1.1-0.7,3.6-0.7,3.6s2.6,0.3,3.5-0.7c1-1.1,0.8-2.1,0-2.9S54.8,37.8,53.8,38.7z' />
					<path style='fill: <?php echo esc_attr( $cart_icon_color ); ?>;' class='st0'
						d='M88.4,35.7c-1.7-2.1-4.3-3.3-7-3.3h-2C77.9,23,69.8,15.7,60,15.7c-9.8,0-17.9,7.2-19.4,16.7h-6.3   c-1.4,0-2.6-1-2.9-2.4l-2.8-13.5c-0.9-4.1-4.6-7.2-8.8-7.2h-7.1c-1.7,0-3,1.3-3,3s1.3,3,3,3h7.1c1.4,0,2.6,1,2.9,2.4l2.8,13.5   c0.9,4.1,4.6,7.2,8.8,7.2h6.3C42,47.8,50.2,55,60,55c9.8,0,17.9-7.2,19.4-16.7h2c0.9,0,1.8,0.4,2.3,1.1c0.6,0.7,0.8,1.6,0.6,2.5   l-4.2,20c-0.3,1.4-1.5,2.4-2.9,2.4H44.1c-4.5,0-8.1,3.6-8.1,8.1c0,3.7,2.5,6.9,6,7.8c-0.2,0.7-0.4,1.5-0.4,2.4   c0,4.5,3.6,8.1,8.1,8.1s8.1-3.6,8.1-8.1c0-0.7-0.1-1.4-0.3-2.1h8.3c-0.2,0.7-0.3,1.4-0.3,2.1c0,4.5,3.6,8.1,8.1,8.1   c4.5,0,8.1-3.6,8.1-8.1s-3.6-8.1-8.1-8.1H44.1c-1.1,0-2.1-0.9-2.1-2.1s0.9-2.1,2.1-2.1h33.1c4.2,0,7.9-3,8.8-7.1l4.2-20   C90.8,40.6,90.1,37.8,88.4,35.7z M60,49c-7.5,0-13.7-6.1-13.7-13.7S52.5,21.7,60,21.7s13.7,6.1,13.7,13.7S67.5,49,60,49z    M73.6,80.5c1.1,0,2.1,0.9,2.1,2.1s-0.9,2.1-2.1,2.1s-2.1-0.9-2.1-2.1S72.5,80.5,73.6,80.5z M49.7,80.5c1.1,0,2.1,0.9,2.1,2.1   s-0.9,2.1-2.1,2.1s-2.1-0.9-2.1-2.1S48.6,80.5,49.7,80.5z' />
					<path style='fill: <?php echo esc_attr( $cart_icon_color ); ?>;' class='st0'
						d='M33.7,50c1.7,0,3-1.3,3-3s-1.3-3-3-3H12.6c-1.7,0-3,1.3-3,3s1.3,3,3,3H33.7z' />
					<path style='fill: <?php echo esc_attr( $cart_icon_color ); ?>;' class='st0'
						d='M42.7,57c0-1.7-1.3-3-3-3H22.2c-1.7,0-3,1.3-3,3s1.3,3,3,3h17.5C41.4,60,42.7,58.7,42.7,57z' />
					<path style='fill: <?php echo esc_attr( $cart_icon_color ); ?>;' class='st0'
						d='M12,54.1c-0.2,0-0.4,0.1-0.6,0.2c-0.2,0.1-0.3,0.2-0.5,0.3c-0.2,0.1-0.3,0.2-0.4,0.4c-0.6,0.6-0.9,1.3-0.9,2.1   c0,0.8,0.3,1.6,0.9,2.1c0.1,0.1,0.3,0.3,0.4,0.4c0.2,0.1,0.3,0.2,0.5,0.3c0.2,0.1,0.4,0.1,0.6,0.2c0.2,0,0.4,0.1,0.6,0.1   c0.8,0,1.6-0.3,2.1-0.9c0.6-0.5,0.9-1.3,0.9-2.1c0-0.8-0.3-1.6-0.9-2.1C14,54.2,13,53.9,12,54.1z' />
				</g>
			</svg>
		<?php endif; ?>
		<?php if ( $icon_name === 'shopping-cart-icon-2' ) : ?>
			<svg width='16' height='17' fill='none' class='radio-icon' viewBox='0 0 100 100'
				style='border-radius: 10px; background: <?php echo esc_attr( $action_btn_active_bg ); ?>;'>
				<g>
					<path style='fill: <?php echo esc_attr( $cart_icon_color ); ?>;' class="st0"
						d="M88.4,35.7c-1.7-2.1-4.3-3.3-7-3.3h-2C77.9,23,69.8,15.7,60,15.7c-9.8,0-17.9,7.2-19.4,16.7h-6.3   c-1.4,0-2.6-1-2.9-2.4l-2.8-13.5c-0.9-4.1-4.6-7.2-8.8-7.2h-7.1c-1.7,0-3,1.3-3,3s1.3,3,3,3h7.1c1.4,0,2.6,1,2.9,2.4l2.8,13.5   c0,0,0,0,0,0l6.7,32c0.6,2.6,2.3,4.8,4.5,6.1c-0.4,1-0.7,2.1-0.7,3.2c0,3.7,2.5,6.9,6,7.8c-0.2,0.7-0.4,1.5-0.4,2.4   c0,4.5,3.6,8.1,8.1,8.1s8.1-3.6,8.1-8.1c0-0.7-0.1-1.4-0.3-2.1h8.3c-0.2,0.7-0.3,1.4-0.3,2.1c0,4.5,3.6,8.1,8.1,8.1   c4.5,0,8.1-3.6,8.1-8.1s-3.6-8.1-8.1-8.1H44.1c-1.1,0-2.1-0.9-2.1-2.1s0.9-2.1,2.1-2.1h33.1c4.2,0,7.9-3,8.8-7.1l4.2-20   C90.8,40.6,90.1,37.8,88.4,35.7z M60,21.7c7.5,0,13.7,6.1,13.7,13.7S67.5,49,60,49s-13.7-6.1-13.7-13.7S52.5,21.7,60,21.7z    M51.8,82.6c0,1.1-0.9,2.1-2.1,2.1c-1.1,0-2.1-0.9-2.1-2.1s0.9-2.1,2.1-2.1C50.9,80.5,51.8,81.5,51.8,82.6z M75.7,82.6   c0,1.1-0.9,2.1-2.1,2.1s-2.1-0.9-2.1-2.1s0.9-2.1,2.1-2.1S75.7,81.5,75.7,82.6z M84.3,42l-4.2,20c-0.3,1.4-1.5,2.4-2.9,2.4H44.1H41   c-1.4,0-2.6-1-2.9-2.4l-5-23.7c0.4,0.1,0.8,0.1,1.2,0.1h6.3C42,47.8,50.2,55,60,55c9.8,0,17.9-7.2,19.4-16.7h2   c0.9,0,1.8,0.4,2.3,1.1C84.3,40.2,84.5,41.1,84.3,42z" />
					<path style='fill: <?php echo esc_attr( $cart_icon_color ); ?>;' class="st0"
						d="M52.8,38.4H57v4.2c0,1.7,1.3,3,3,3s3-1.3,3-3v-4.2h4.2c1.7,0,3-1.3,3-3s-1.3-3-3-3H63v-4.2c0-1.7-1.3-3-3-3   s-3,1.3-3,3v4.2h-4.2c-1.7,0-3,1.3-3,3S51.1,38.4,52.8,38.4z" />
				</g>
			</svg>
		<?php endif; ?>
		<?php if ( $icon_name === 'shopping-cart-icon-3' ) : ?>
			<svg width='16' height='17' fill='none' class='radio-icon' viewBox='0 0 100 100'
				style='  border-radius: 10px; background: <?php echo esc_attr( $action_btn_active_bg ); ?>;'>
				<g>
					<path style='fill: <?php echo esc_attr( $cart_icon_color ); ?>;' class="st0"
						d="M88.4,35.7c-1.7-2.1-4.3-3.3-7-3.3h-2C77.9,23,69.8,15.7,60,15.7S42,23,40.6,32.4h-6.3c-1.4,0-2.6-1-2.9-2.4   l-2.8-13.5c-0.9-4.1-4.6-7.2-8.8-7.2h-7.1c-1.7,0-3,1.3-3,3s1.3,3,3,3h7.1c1.4,0,2.6,1,2.9,2.4l2.8,13.5c0,0,0,0,0,0l6.7,32   c0.6,2.6,2.3,4.8,4.5,6.1c-0.4,1-0.7,2.1-0.7,3.2c0,3.7,2.5,6.9,6,7.8c-0.2,0.7-0.4,1.5-0.4,2.4c0,4.5,3.6,8.1,8.1,8.1   c4.5,0,8.1-3.6,8.1-8.1c0-0.7-0.1-1.4-0.3-2.1h8.3c-0.2,0.7-0.3,1.4-0.3,2.1c0,4.5,3.6,8.1,8.1,8.1c4.5,0,8.1-3.6,8.1-8.1   s-3.6-8.1-8.1-8.1H44.1c-1.1,0-2.1-0.9-2.1-2.1s0.9-2.1,2.1-2.1h33.1c4.2,0,7.9-3,8.8-7.1l4.2-20C90.8,40.6,90.1,37.8,88.4,35.7z    M60,21.7c7.5,0,13.7,6.1,13.7,13.7C73.6,42.9,67.5,49,60,49s-13.7-6.1-13.7-13.7C46.3,27.9,52.5,21.7,60,21.7z M51.8,82.6   c0,1.1-0.9,2.1-2.1,2.1s-2.1-0.9-2.1-2.1s0.9-2.1,2.1-2.1S51.8,81.5,51.8,82.6z M75.7,82.6c0,1.1-0.9,2.1-2.1,2.1s-2.1-0.9-2.1-2.1   s0.9-2.1,2.1-2.1S75.7,81.5,75.7,82.6z M84.3,42l-4.2,20c-0.3,1.4-1.5,2.4-2.9,2.4H44.1H41c-1.4,0-2.6-1-2.9-2.4l-5-23.7   c0.4,0.1,0.8,0.1,1.2,0.1h6.3C42,47.8,50.2,55,60,55s17.9-7.2,19.4-16.7h2c0.9,0,1.8,0.4,2.3,1.1S84.5,41.1,84.3,42z" />
					<path style='fill: <?php echo esc_attr( $cart_icon_color ); ?>;' class="st0"
						d="M56,36c0.8,0.3,1.8,0.6,3.1,1v4c-0.7-0.2-1.1-0.7-1.3-1.4C57.7,39.3,57.4,39,57,39h-3c-0.5,0-0.9,0.5-0.8,1   c0.2,1.1,0.8,2,1.6,2.8c1.1,0.9,2.5,1.4,4.3,1.6v1.3c0,0.4,0.4,0.8,0.8,0.8c0.4,0,0.8-0.4,0.8-0.8v-1.2c1.3-0.1,2.4-0.3,3.3-0.8   c0.9-0.5,1.6-1.1,2.1-1.9c0.5-0.8,0.7-1.6,0.7-2.5c0-1.2-0.3-2.2-0.9-2.8c-0.6-0.7-1.3-1.2-2-1.5c-0.8-0.3-1.8-0.6-3.2-1v-3.9   c0.6,0.2,1,0.6,1.2,1.2c0.1,0.3,0.4,0.5,0.8,0.5h3c0.5,0,0.9-0.5,0.8-1c-0.2-1.1-0.8-2-1.6-2.7c-1-0.9-2.4-1.4-4.2-1.5v-1.2   c0-0.4-0.4-0.8-0.8-0.8c-0.4,0-0.8,0.4-0.8,0.8v1.2c-1.8,0.1-3.2,0.6-4.4,1.6c-1.1,0.9-1.7,2.1-1.7,3.7c0,1.2,0.3,2.2,0.9,2.9   C54.6,35.2,55.3,35.7,56,36z M60.8,37.5c0.5,0.2,0.9,0.4,1.2,0.7c0.3,0.3,0.4,0.6,0.4,1.1c0,0.5-0.1,0.9-0.4,1.2   c-0.3,0.3-0.7,0.5-1.2,0.6V37.5z M58,30.3c0.3-0.3,0.6-0.5,1.1-0.5v3.5c-0.5-0.2-0.9-0.5-1.1-0.8c-0.3-0.3-0.4-0.6-0.4-1.1   C57.6,30.9,57.8,30.6,58,30.3z" />
				</g>
			</svg>
		<?php endif; ?>
		<?php if ( $icon_name === 'shopping-cart-icon-4' ) : ?>
			<svg width='16' height='17' fill='none' class='radio-icon' viewBox='0 0 100 100'
				style='  border-radius: 10px; background: <?php echo esc_attr( $action_btn_active_bg ); ?>;'>
				<g>
					<path style='fill: <?php echo esc_attr( $cart_icon_color ); ?>;' class="st0"
						d="M88.5,28.8C87,27,84.8,26,82.4,26H32.2c-1,0-1.8-0.7-2-1.7l-1-4.9l-0.6-2.9c0,0,0,0,0,0l-0.2-0.7   c-0.8-3.7-4.1-6.4-7.9-6.4h-7.9c-1.7,0-3,1.3-3,3s1.3,3,3,3h7.9c1,0,1.8,0.7,2,1.7l0.5,2.3l9.2,43.9c0.6,2.6,2.3,4.8,4.5,6.1   c-0.4,1-0.7,2.1-0.7,3.2c0,3.7,2.5,6.9,6,7.8c-0.2,0.7-0.4,1.5-0.4,2.4c0,4.5,3.6,8.1,8.1,8.1c4.5,0,8.1-3.6,8.1-8.1   c0-0.7-0.1-1.4-0.3-2.1h8.3c-0.2,0.7-0.3,1.4-0.3,2.1c0,4.5,3.6,8.1,8.1,8.1s8.1-3.6,8.1-8.1s-3.6-8.1-8.1-8.1H44.1   c-1.1,0-2.1-0.9-2.1-2.1s0.9-2.1,2.1-2.1h33.7c4,0,7.3-2.8,8-6.8l4.7-28.2C90.7,33,90.1,30.6,88.5,28.8z M51.8,82.6   c0,1.1-0.9,2.1-2.1,2.1c-1.1,0-2.1-0.9-2.1-2.1s0.9-2.1,2.1-2.1C50.8,80.5,51.8,81.5,51.8,82.6z M73.6,84.7c-1.1,0-2.1-0.9-2.1-2.1   s0.9-2.1,2.1-2.1s2.1,0.9,2.1,2.1S74.7,84.7,73.6,84.7z M84.4,34.4l-4.7,28.2c-0.2,1-1,1.7-2.1,1.7H44.1h-3.1c-1.4,0-2.6-1-2.9-2.4   l-6.3-30c0.1,0,0.3,0,0.4,0h50.2c0.8,0,1.4,0.5,1.6,0.7C84.2,33,84.6,33.6,84.4,34.4z" />
					<path style='fill: <?php echo esc_attr( $cart_icon_color ); ?>;' class="st0"
						d="M58.2,38.1c-1.7,0-3,1.3-3,3V57c0,1.7,1.3,3,3,3s3-1.3,3-3V41.1C61.2,39.4,59.8,38.1,58.2,38.1z" />
					<path style='fill: <?php echo esc_attr( $cart_icon_color ); ?>;' class="st0"
						d="M72.4,38.6c-1.6-0.4-3.2,0.6-3.6,2.3l-3.4,15.1c-0.4,1.6,0.6,3.2,2.3,3.6c0.2,0.1,0.4,0.1,0.7,0.1   c1.4,0,2.6-0.9,2.9-2.3l3.4-15.1C75.1,40.5,74.1,38.9,72.4,38.6z" />
					<path style='fill: <?php echo esc_attr( $cart_icon_color ); ?>;' class="st0"
						d="M47.5,40.8c-0.4-1.6-2-2.6-3.6-2.3c-1.6,0.4-2.6,2-2.3,3.6l3.4,15.1c0.3,1.4,1.6,2.3,2.9,2.3   c0.2,0,0.4,0,0.7-0.1c1.6-0.4,2.6-2,2.3-3.6L47.5,40.8z" />
				</g>
			</svg>
		<?php endif; ?>
		<?php if ( $icon_name === 'shopping-cart-icon-5' ) : ?>
			<svg width='16' height='17' fill='none' class='radio-icon' viewBox='0 0 25 25'
				style='  border-radius: 10px; background: <?php echo esc_attr( $action_btn_active_bg ); ?>;'>
				<g>
				<path d="M3.06164 15.1933L3.42688 13.1219C3.85856 10.6736 4.0744 9.44952 4.92914 8.72476C5.78389 8 7.01171 8 9.46734 8H14.5327C16.9883 8 18.2161 8 19.0709 8.72476C19.9256 9.44952 20.1414 10.6736 20.5731 13.1219L20.9384 15.1933C21.5357 18.5811 21.8344 20.275 20.9147 21.3875C19.995 22.5 18.2959 22.5 14.8979 22.5H9.1021C5.70406 22.5 4.00504 22.5 3.08533 21.3875C2.16562 20.275 2.4643 18.5811 3.06164 15.1933Z" stroke="<?php echo esc_attr( $cart_icon_color ); ?>" stroke-width="1.5"/>

<path d="M6.375 8L6.58477 5.98618C6.81947 3.73306 9.17384 2 12 2C14.8261 2 17.1805 3.73306 17.4152 5.98618L17.625 8" stroke="<?php echo esc_attr( $cart_icon_color ); ?>" stroke-width="1.5"/>

<path d="M15.75 11C15.5875 12.4131 13.9571 13.5 12 13.5C10.0429 13.5 8.41252 12.4131 8.25 11" stroke="<?php echo esc_attr( $cart_icon_color ); ?>" stroke-width="1.5" stroke-linecap="round"/>
				</g>
			</svg>
		<?php endif; ?>
		<span class="wfc-cart-countlocation">
			<?php echo esc_html( wc()->cart->get_cart_contents_count() ); ?>
		</span>
	</span>
</div>

<div class="wfc-overlay wfc-hide"></div>
<div class="wfc-widget-sidebar <?php echo esc_attr( sp_store_growth()->has_pro() ? $class_name : '' ); ?> wfc-slide ">
<span class="qc-close-nav">
<svg xmlns="http://www.w3.org/2000/svg" width="14" height="8" viewBox="0 0 14 8" fill="none">
<path d="M1 1L4.72223 5.3426C5.91952 6.73944 8.08048 6.73944 9.27777 5.3426L13 1" stroke="#073B4C" stroke-width="2" stroke-linecap="round"/>
</svg>
</span>
	<div class="qc-cart-heading">
		<h3 class="wfc-cart-heading">
			<?php esc_html_e( 'Shopping Cart', 'storegrowth-sales-booster' ); ?>
			<div class="wfc-cart-countlocation">
				<?php echo esc_html( wc()->cart->get_cart_contents_count() ); ?>
		</div>
		</h3>
		<span class="wfc-close-btn spsg-cart-widget-close" title="Close">
			<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="none">
			<path d="M13.9697 15.0303C14.2626 15.3232 14.7374 15.3232 15.0303 15.0303C15.3232 14.7374 15.3232 14.2626 15.0303 13.9697L11.0607 10L15.0303 6.03033C15.3232 5.73744 15.3232 5.26256 15.0303 4.96967C14.7374 4.67678 14.2626 4.67678 13.9697 4.96967L10 8.93934L6.03033 4.96967C5.73744 4.67678 5.26256 4.67678 4.96967 4.96967C4.67678 5.26256 4.67678 5.73744 4.96967 6.03033L8.93934 10L4.96967 13.9697C4.67678 14.2626 4.67678 14.7374 4.96967 15.0303C5.26256 15.3232 5.73744 15.3232 6.03033 15.0303L10 11.0607L13.9697 15.0303Z" fill="#303030"/>
			</svg>
		</span>
	</div>
	<div class="spsg-widget-shopping-cart-content-wrapper">
		<div class="spsg-widget-shopping-cart-content"></div>
		<div class="spsg-page-loader spsg-fly-cart-loader">
			<div class="spsg-page-loader-ring"></div>
		</div>
	</div>
</div>
