<?php
/**
 * Template Name: Mes Achats
 */

global $wp;

// Get current user ID
$user_id = get_current_user_id();

// Get user orders as a customer
$customer_orders = wc_get_orders( array(
    'customer_id' => $user_id,
    'limit'       => 50,
    'orderby'     => 'date',
    'order'       => 'DESC',
    'status'      => array_keys( wc_get_order_statuses() ),
) );

// If no orders via API, try direct query
if ( empty( $customer_orders ) ) {
    global $wpdb;
    
    // Check if using HPOS
    $hpos_enabled = false;
    if ( class_exists( '\Automattic\WooCommerce\Utilities\OrderUtil' ) ) {
        $hpos_enabled = \Automattic\WooCommerce\Utilities\OrderUtil::custom_orders_table_usage_is_enabled();
    }
    
    if ( $hpos_enabled ) {
        $order_ids = $wpdb->get_col( $wpdb->prepare( "
            SELECT id FROM {$wpdb->prefix}wc_orders
            WHERE customer_id = %d
            AND status NOT IN ('trash', 'auto-draft')
            ORDER BY date_created_gmt DESC
            LIMIT 50
        ", $user_id ) );
    } else {
        $order_ids = $wpdb->get_col( $wpdb->prepare( "
            SELECT p.ID FROM {$wpdb->prefix}posts p
            INNER JOIN {$wpdb->prefix}postmeta pm ON p.ID = pm.post_id
            WHERE p.post_type = 'shop_order'
            AND p.post_status NOT IN ('trash', 'auto-draft', 'wc-checkout-draft')
            AND pm.meta_key = '_customer_user'
            AND pm.meta_value = %d
            ORDER BY p.post_date DESC
            LIMIT 50
        ", $user_id ) );
    }
    
    $customer_orders = array();
    foreach ( $order_ids as $order_id ) {
        $order = wc_get_order( $order_id );
        if ( $order ) {
            $customer_orders[] = $order;
        }
    }
}
?>

<!-- DOKAN DASHBOARD WRAPPER -->
<div class="dokan-dashboard-wrap">
    
    <!-- DOKAN SIDEBAR MENU -->
    <?php 
    // Load Dokan sidebar navigation
    dokan_get_template_part( 'global/dashboard-nav', '', array( 'active_menu' => 'my-purchases' ) ); 
    ?>
    
    <!-- MAIN CONTENT AREA -->
    <div class="dokan-dashboard-content dokan-purchases-content">
        
        <!-- CONTENT HEADER -->
        <header class="dokan-dashboard-header">
            <h1 class="entry-title"><?php _e( 'Mes Achats', 'glowup' ); ?></h1>
        </header>
        
        <!-- ORDERS TABLE -->
        <?php if ( ! empty( $customer_orders ) ) : ?>
            <div class="dokan-order-wrapper">
                <table class="dokan-table dokan-table-striped dokan-purchases-table">
                    <thead>
                        <tr>
                            <th><?php _e( 'Commande', 'dokan-lite' ); ?></th>
                            <th><?php _e( 'Date', 'dokan-lite' ); ?></th>
                            <th><?php _e( 'État', 'dokan-lite' ); ?></th>
                            <th><?php _e( 'Total', 'dokan-lite' ); ?></th>
                            <th><?php _e( 'Actions', 'dokan-lite' ); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ( $customer_orders as $order ) : ?>
                            <tr>
                                <td class="dokan-order-id">
                                    <a href="<?php echo esc_url( $order->get_view_order_url() ); ?>">
                                        <strong>#<?php echo $order->get_order_number(); ?></strong>
                                    </a>
                                </td>
                                <td class="dokan-order-date">
                                    <?php echo esc_html( wc_format_datetime( $order->get_date_created() ) ); ?>
                                </td>
                                <td class="dokan-order-status">
                                    <span class="dokan-label dokan-label-<?php echo esc_attr( $order->get_status() ); ?>">
                                        <?php echo esc_html( wc_get_order_status_name( $order->get_status() ) ); ?>
                                    </span>
                                </td>
                                <td class="dokan-order-total">
                                    <?php echo $order->get_formatted_order_total(); ?>
                                </td>
                                <td class="dokan-order-action">
                                    <a href="<?php echo esc_url( add_query_arg( 'order_id', $order->get_id(), dokan_get_navigation_url( 'my-purchases' ) ) ); ?>" class="dokan-btn dokan-btn-default dokan-btn-sm">
                                        <i class="fas fa-eye"></i> <?php _e( 'Voir', 'dokan-lite' ); ?>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else : ?>
            <div class="dokan-alert dokan-alert-info">
                <p><?php _e( 'Aucune commande trouvée. Vous n\'avez pas encore effectué d\'achats sur ce site.', 'glowup' ); ?></p>
            </div>
        <?php endif; ?>
        
    </div> <!-- .dokan-dashboard-content -->
    
</div> <!-- .dokan-dashboard-wrap -->

<style>
/* Fix Dokan Dashboard Layout */
.dokan-dashboard-wrap {
    display: flex;
    width: 100%;
    max-width: 100%;
    margin: 0;
    padding: 0;
    background: #f5f5f5;
    min-height: calc(100vh - 100px);
}

.dokan-dashboard-nav {
    width: 230px;
    min-width: 230px;
    background: #fff;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    margin-right: 20px;
}

.dokan-dashboard-content {
    flex: 1;
    padding: 30px;
    background: #fff;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    border-radius: 4px;
    margin-left: 0;
    overflow-x: auto;
}

.dokan-dashboard-header {
    margin-bottom: 30px;
    padding-bottom: 20px;
    border-bottom: 1px solid #e5e5e5;
}

.dokan-dashboard-header h1 {
    margin: 0;
    color: #333;
    font-size: 24px;
    font-weight: 600;
}

/* Table Styles */
.dokan-purchases-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 20px;
}

.dokan-purchases-table th {
    background: #f8f9fa;
    padding: 15px;
    text-align: left;
    font-weight: 600;
    color: #495057;
    border-bottom: 2px solid #e9ecef;
}

.dokan-purchases-table td {
    padding: 15px;
    border-bottom: 1px solid #e9ecef;
    vertical-align: middle;
}

.dokan-purchases-table tr:hover {
    background: #f8f9fa;
}

.dokan-order-id a {
    color: #0073aa;
    font-weight: 600;
    text-decoration: none;
}

.dokan-order-id a:hover {
    color: #00a0d2;
    text-decoration: underline;
}

/* Status Labels */
.dokan-label {
    display: inline-block;
    padding: 4px 12px;
    border-radius: 3px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
}

.dokan-label-completed {
    background: #d4edda;
    color: #155724;
}

.dokan-label-processing {
    background: #cce5ff;
    color: #004085;
}

.dokan-label-shipping{
    background: #8700c5ff;
    color: #000000ff;
}

.dokan-label-on-hold {
    background: #fff3cd;
    color: #856404;
}

.dokan-label-pending {
    background: #ffeaa7;
    color: #856404;
}

.dokan-label-cancelled, 
.dokan-label-failed {
    background: #f8d7da;
    color: #721c24;
}

/* Buttons */
.dokan-order-action .dokan-btn {
    padding: 6px 12px;
    font-size: 14px;
    background: #6c757d;
    color: white;
    border: none;
    border-radius: 3px;
    transition: all 0.2s;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    gap: 5px;
}

.dokan-order-action .dokan-btn:hover {
    background: #5a6268;
    color: white;
    transform: translateY(-1px);
}

/* Alert */
.dokan-alert-info {
    background: #d1ecf1;
    border-color: #bee5eb;
    color: #0c5460;
    padding: 20px;
    border-radius: 4px;
    margin-top: 20px;
}

/* Responsive */
@media (max-width: 768px) {
    .dokan-dashboard-wrap {
        flex-direction: column;
    }
    
    .dokan-dashboard-nav {
        width: 100%;
        margin-right: 0;
        margin-bottom: 20px;
    }
    
    .dokan-dashboard-content {
        padding: 15px;
    }
    
    .dokan-purchases-table {
        display: block;
        overflow-x: auto;
        white-space: nowrap;
    }
}
</style>