<?php
add_action( 'wp_enqueue_scripts', 'martfury_child_enqueue_scripts', 20 );
function martfury_child_enqueue_scripts() {
	wp_enqueue_style( 'martfury-child-style', get_stylesheet_uri() );
	if ( is_rtl() ) {
		wp_enqueue_style( 'martfury-rtl', get_template_directory_uri() . '/rtl.css', array(), '20180105' );
	}
}
add_shortcode('martfury_icons', function() {
    ob_start();

    // 1. Enqueue Styles (Ensure the theme CSS and Icon Fonts are loaded)
    if ( ! wp_style_is( 'martfury', 'enqueued' ) ) {
        wp_enqueue_style( 'martfury' );
    }
    // Explicitly enqueue icon fonts if they aren't showing
    wp_enqueue_style( 'linearicons' );
    wp_enqueue_style( 'font-awesome' );

    // 2. Load Extra Functions
    if (!function_exists('martfury_extra_wislist')) {
        $extra = get_template_directory() . '/inc/functions-extra.php';
        if (file_exists($extra)) {
            include_once $extra;
        }
    }

    // 3. Output HTML with Structural Wrappers
    // We wrap the list in 'site-header' and 'header-extras' so the theme's CSS recognizes it.
    ?>
    <div class="site-header martfury-shortcode-wrapper" style="background:transparent; border:none; min-height:auto;">
        <div class="header-main">
            <div class="header-extras" style="display:flex; align-items:center;">
                <ul class="extras-menu">
                    <?php
                    // WISHLIST
                    if (function_exists('martfury_extra_wislist')) {
                        martfury_extra_wislist();
                    }
					// COMPARE 
					if (function_exists('martfury_extra_compare')) {
                        martfury_extra_compare();
                    }
                    // CART
                    if (function_exists('martfury_extra_cart')) {
                        martfury_extra_cart();
                    }

                    // ACCOUNT
                    if (function_exists('martfury_extra_account')) {
                        martfury_extra_account();
                    }
                    ?>
                </ul>
            </div>
        </div>
    </div>
    <?php

    return ob_get_clean();
});

add_action( 'wp', function() {
    remove_action( 'martfury_header', 'martfury_header_layout', 10 );
});

add_filter( 'dokan_can_post_product', '__return_false' );

add_filter('dokan_new_vendor_enabled', function() {
    return 'pending';
});
